package gov.va.vinci.dart.dms.db.impl;

import java.util.List;

import javax.persistence.Query;

import gov.va.vinci.dart.db.util.HibernateDAO;
import gov.va.vinci.dart.dms.biz.Content;
import gov.va.vinci.dart.dms.db.ContentDAO;

public class ContentDAOImpl extends HibernateDAO implements ContentDAO {

	@Override
	public Content findById(final int contentId) {
		Query q = createQuery("from Content where id=:cid");
		q.setParameter("cid", contentId);
		return (Content)q.getSingleResult();
	}
	
	@Override
	@SuppressWarnings("unchecked")
	public List<Content> listByRepository(final int repositoryId) {
		Query q = createQuery("from Content where repository.id=:rid order by id");
		q.setParameter("rid", repositoryId);
		return (List<Content>)q.getResultList();
	}

	@Override
	public void save(Content content) {
		if (content == null) {
			throw new IllegalArgumentException();
		}
			
		HibernateDAO.save(content);
	}

}
